(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     17197,        605]*)
(*NotebookOutlinePosition[     18128,        636]*)
(*  CellTagsIndexPosition[     18084,        632]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Find a Third Solution", "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"Given that you know two linearly independent solutions of a third order \
differential equation, how can you find the third? Here is an example which \
illustrates one method."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData["Construct an equation from known solutions"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Clear[x, y, v, w, u, L]\)], "Input",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(L[0]\)[x_, y_] = 
      Collect[Cancel[
          Wronskian[{x, x\^3, Exp[x], y[x]}, x]\/\(2\ \((\(-E\^x\))\)\)], 
        y]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    RowBox[{\(\(-3\)\ y[x]\), "+", \(3\ x\ y[x]\), "+", 
      RowBox[{"3", " ", "x", " ", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}], "-", 
      RowBox[{"3", " ", \(x\^2\), " ", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}], "+", 
      RowBox[{"3", " ", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}], "-", 
      RowBox[{"3", " ", "x", " ", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}], "+", 
      RowBox[{\(x\^3\), " ", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}], "-", 
      RowBox[{"3", " ", "x", " ", 
        RowBox[{
          SuperscriptBox["y", 
            TagBox[\((3)\),
              Derivative],
            MultilineFunction->None], "[", "x", "]"}]}], "+", 
      RowBox[{"3", " ", \(x\^2\), " ", 
        RowBox[{
          SuperscriptBox["y", 
            TagBox[\((3)\),
              Derivative],
            MultilineFunction->None], "[", "x", "]"}]}], "-", 
      RowBox[{\(x\^3\), " ", 
        RowBox[{
          SuperscriptBox["y", 
            TagBox[\((3)\),
              Derivative],
            MultilineFunction->None], "[", "x", "]"}]}]}]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(L[0]\)[x, y] \[Equal] 0\)], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(\(-3\)\ y[x]\), "+", \(3\ x\ y[x]\), "+", 
        RowBox[{"3", " ", "x", " ", 
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}]}], "-", 
        RowBox[{"3", " ", \(x\^2\), " ", 
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}]}], "+", 
        RowBox[{"3", " ", 
          RowBox[{
            SuperscriptBox["y", "\[Prime]\[Prime]",
              MultilineFunction->None], "[", "x", "]"}]}], "-", 
        RowBox[{"3", " ", "x", " ", 
          RowBox[{
            SuperscriptBox["y", "\[Prime]\[Prime]",
              MultilineFunction->None], "[", "x", "]"}]}], "+", 
        RowBox[{\(x\^3\), " ", 
          RowBox[{
            SuperscriptBox["y", "\[Prime]\[Prime]",
              MultilineFunction->None], "[", "x", "]"}]}], "-", 
        RowBox[{"3", " ", "x", " ", 
          RowBox[{
            SuperscriptBox["y", 
              TagBox[\((3)\),
                Derivative],
              MultilineFunction->None], "[", "x", "]"}]}], "+", 
        RowBox[{"3", " ", \(x\^2\), " ", 
          RowBox[{
            SuperscriptBox["y", 
              TagBox[\((3)\),
                Derivative],
              MultilineFunction->None], "[", "x", "]"}]}], "-", 
        RowBox[{\(x\^3\), " ", 
          RowBox[{
            SuperscriptBox["y", 
              TagBox[\((3)\),
                Derivative],
              MultilineFunction->None], "[", "x", "]"}]}]}], "==", 
      "0"}]], "Output"]
}, Closed]],

Cell[TextData[
"Notice that this equation does not have constant coefficients."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData["Check the solutions"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData["First, x."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[{
    \(y1[x_] = x\), "\n", 
    \(Simplify[\(L[0]\)[x, y1] == 0]\)}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(x\)], "Output"],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[TextData["Then x^2."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[{
    \(y2[x_] = x\^3\), "\n", 
    \(Simplify[\(L[0]\)[x, y2] == 0]\)}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(x\^3\)], "Output"],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[TextData["Then E^x."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[{
    \(y3[x_] = E\^x\), "\n", 
    \(Simplify[\(L[0]\)[x, y3] == 0]\)}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(\[ExponentialE]\^x\)], "Output"],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[TextData[
"All three solutions check,but we are going to pretend that we only know that \
x and x^3 are solutions. We want to find the third."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Find a third solution"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"Assume that we know y1[x_] = x  to be a solution. Find a second solution \
using y2[x_] = x^3  which we also know."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(u[x_] = y1[x]\ v[x]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(x\ v[x]\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{\(\(L[1]\)[x_, v_]\), "=", 
      RowBox[{"Collect", "[", 
        RowBox[{
          RowBox[{"Simplify", "[", 
            RowBox[{\(\(L[0]\)[x, u]\), "/.", 
              RowBox[{
                RowBox[{
                  SuperscriptBox["u", 
                    TagBox[\((p_)\),
                      Derivative],
                    MultilineFunction->None], "[", "x", "]"}], 
                "\[Rule]", \(\[PartialD]\_{x, p}u[x]\)}]}], "]"}], ",", "v"}],
         "]"}]}]], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    RowBox[{
      RowBox[{\(-\((\(-6\) + 6\ x - 3\ x\^2 + x\^3)\)\), " ", 
        RowBox[{
          SuperscriptBox["v", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}], "+", 
      RowBox[{"x", " ", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{\((\(-6\) + 6\ x - 3\ x\^2 + x\^3)\), " ", 
              RowBox[{
                SuperscriptBox["v", "\[Prime]\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}]}], "-", 
            RowBox[{"x", " ", \((3 - 3\ x + x\^2)\), " ", 
              RowBox[{
                SuperscriptBox["v", 
                  TagBox[\((3)\),
                    Derivative],
                  MultilineFunction->None], "[", "x", "]"}]}]}], 
          ")"}]}]}]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{\(\(L[2]\)[x_, w_]\), "=", 
      RowBox[{\(\(L[1]\)[x, v]\), "/.", 
        RowBox[{
          RowBox[{
            SuperscriptBox["v", 
              TagBox[\((p_)\),
                Derivative],
              MultilineFunction->None], "[", "x", "]"}], "\[Rule]", 
          RowBox[{
            SuperscriptBox["w", 
              TagBox[\((p - 1)\),
                Derivative],
              MultilineFunction->None], "[", "x", "]"}]}]}]}]], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    RowBox[{\(\(-\((\(-6\) + 6\ x - 3\ x\^2 + x\^3)\)\)\ w[x]\), "+", 
      RowBox[{"x", " ", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{\((\(-6\) + 6\ x - 3\ x\^2 + x\^3)\), " ", 
              RowBox[{
                SuperscriptBox["w", "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}]}], "-", 
            RowBox[{"x", " ", \((3 - 3\ x + x\^2)\), " ", 
              RowBox[{
                SuperscriptBox["w", "\[Prime]\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}]}]}], 
          ")"}]}]}]], "Output"]
}, Closed]],

Cell[TextData[
"We know that y2[x]= y1[x] v[x], since y1[x] is a solution. Hence, v[x] = \
y2[x]/y1[x], and w[x] = D[v[x],x] should be a solution of L[2][x,w]==0."], 
  "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(w1[x_] = \[PartialD]\_x\( y2[x]\/y1[x]\)\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(2\ x\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[\(L[2]\)[x, w1]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(0\)], "Output"]
}, Closed]],

Cell[TextData[
"Use this known solution to reduce the order once more."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[{
    \(Clear[v]\), "\n", 
    \(u[x_] = w1[x]\ v[x]\)}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(2\ x\ v[x]\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{\(\(L[3]\)[x_, v_]\), "=", 
      RowBox[{"Collect", "[", 
        RowBox[{
          RowBox[{"Simplify", "[", 
            RowBox[{\(\(L[2]\)[x, u]\), "/.", 
              RowBox[{
                RowBox[{
                  SuperscriptBox["u", 
                    TagBox[\((p_)\),
                      Derivative],
                    MultilineFunction->None], "[", "x", "]"}], 
                "\[Rule]", \(\[PartialD]\_{x, p}u[x]\)}]}], "]"}], ",", "v"}],
         "]"}]}]], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    RowBox[{"2", " ", \(x\^2\), " ", 
      RowBox[{"(", 
        RowBox[{
          RowBox[{\((\(-12\) + 12\ x - 5\ x\^2 + x\^3)\), " ", 
            RowBox[{
              SuperscriptBox["v", "\[Prime]",
                MultilineFunction->None], "[", "x", "]"}]}], "-", 
          RowBox[{"x", " ", \((3 - 3\ x + x\^2)\), " ", 
            RowBox[{
              SuperscriptBox["v", "\[Prime]\[Prime]",
                MultilineFunction->None], "[", "x", "]"}]}]}], 
        ")"}]}]], "Output"]
}, Closed]],

Cell[TextData["Now let w[x] = v'[x]. Do this by substitution."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[{\(Clear[w]\), "\n", 
    RowBox[{\(\(L[4]\)[x_, w_]\), "=", 
      RowBox[{\(\(L[3]\)[x, v]\), "/.", 
        RowBox[{
          RowBox[{
            SuperscriptBox["v", 
              TagBox[\((p_)\),
                Derivative],
              MultilineFunction->None], "[", "x", "]"}], "\[Rule]", 
          RowBox[{
            SuperscriptBox["w", 
              TagBox[\((p - 1)\),
                Derivative],
              MultilineFunction->None], "[", "x", "]"}]}]}]}]}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    RowBox[{"2", " ", \(x\^2\), " ", 
      RowBox[{"(", 
        RowBox[{\(\((\(-12\) + 12\ x - 5\ x\^2 + x\^3)\)\ w[x]\), "-", 
          RowBox[{"x", " ", \((3 - 3\ x + x\^2)\), " ", 
            RowBox[{
              SuperscriptBox["w", "\[Prime]",
                MultilineFunction->None], "[", "x", "]"}]}]}], 
        ")"}]}]], "Output"]
}, Closed]],

Cell[TextData["Now, w[x]=E^pwr[x], where"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{\(pwr[x_]\), "=", 
      RowBox[{"-", 
        RowBox[{"\[Integral]", 
          RowBox[{
            FractionBox[\(Coefficient[Expand[\(L[4]\)[x, w]], w[x]]\), 
              RowBox[{"Coefficient", "[", 
                RowBox[{\(Expand[\(L[4]\)[x, w]]\), ",", 
                  RowBox[{
                    SuperscriptBox["w", "\[Prime]",
                      MultilineFunction->None], "[", "x", "]"}]}], 
                "]"}]], \(\[DifferentialD]x\)}]}]}]}]], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(x - 4\ Log[x] + Log[3 - 3\ x + x\^2]\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(w[x_] = Exp[pwr[x]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(\[ExponentialE]\^\(x - 4\ Log[x] + Log[3 - 3\ x + x\^2]\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[\(L[4]\)[x, w] == 0]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[TextData[
"We now need to recover a third solution to L[0][x,y]==0 from w[x], but we \
should force a simplification first. Do this by renaming the Exp function to \
myExp, repeatedly reducing myExp & Log, and finally restoring the name Exp. \
This is a sequence of three substitution steps, with the middle step \
repeated."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(w[x_] = \(\(w[x] /. 
            E\^pp_ \[Rule] 
              myExp[pp]\) //. {myExp[c_. \ \((a_ + b_)\)] \[Rule] 
              myExp[c\ a]\ myExp[c\ b], myExp[a_. \ Log[pp_]] \[Rule] pp\^a, 
            myExp[Log[pp_]] \[Rule] pp}\) /. myExp \[Rule] Exp\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(\(\[ExponentialE]\^x\ \((3 - 3\ x + x\^2)\)\)\/x\^4\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[\(L[4]\)[x, w] == 0]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[TextData["Now v'[x]=w[x], so"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(v[x_] = \[Integral]w[x] \[DifferentialD]x\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(\[ExponentialE]\^x\ \((\(-\(1\/x\^3\)\) + 1\/x\^2)\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(s[x_] = \[Integral]\(\[PartialD]\_x\( y2[x]\/y1[
                    x]\)\ %\) \[DifferentialD]x\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(\(2\ \[ExponentialE]\^x\)\/x\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(Clear[y3]\), "\n", 
    \(y3[x_] = y1[x]\ s[x]\)}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(2\ \[ExponentialE]\^x\)], "Output"]
}, Closed]],

Cell[TextData["This is our third solution!"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[\(L[0]\)[x, y3] == 0]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Initialization: The Wronskian"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"This  definition of the Wronskian automatically determines the number of \
derivatives which are required and constructs a matrix having the necessary \
additional rows. It then calculates the determinant and simplifies, leaving \
the answer factored."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[{
    \(Clear[Wronskian]\), "\n", 
    \(Wronskian[functions_List, var_] := 
      Factor[Simplify[
          Det[Table[\[PartialD]\_{var, i}functions, {i, 0, 
                Length[functions] - 1}]]]]\)}], "Input",
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
AutoGeneratedPackage->None,
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{543, 565},
WindowMargins->{{20, Automatic}, {Automatic, 28}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 90, 2, 65, "Subtitle",
  Evaluatable->False],
Cell[1869, 57, 251, 5, 50, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2145, 66, 120, 2, 56, "Section",
  Evaluatable->False],
Cell[2268, 70, 82, 2, 27, "Input"],

Cell[CellGroupData[{
Cell[2375, 76, 187, 5, 65, "Input"],
Cell[2565, 83, 1479, 39, 47, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[4081, 127, 58, 1, 27, "Input"],
Cell[4142, 130, 1590, 41, 47, "Output"]
}, Closed]],
Cell[5747, 174, 138, 3, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[5910, 181, 100, 2, 46, "Subsection",
  Evaluatable->False],
Cell[6013, 185, 84, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[6122, 191, 119, 3, 43, "Input"],
Cell[6244, 196, 35, 1, 27, "Output"],
Cell[6282, 199, 38, 1, 27, "Output"]
}, Closed]],
Cell[6335, 203, 84, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[6444, 209, 122, 3, 45, "Input"],
Cell[6569, 214, 38, 1, 29, "Output"],
Cell[6610, 217, 38, 1, 27, "Output"]
}, Closed]],
Cell[6663, 221, 84, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[6772, 227, 122, 3, 43, "Input"],
Cell[6897, 232, 52, 1, 27, "Output"],
Cell[6952, 235, 38, 1, 27, "Output"]
}, Closed]],
Cell[7005, 239, 206, 4, 50, "Text",
  Evaluatable->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[7260, 249, 98, 2, 36, "Section",
  Evaluatable->False],
Cell[7361, 253, 190, 4, 50, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[7576, 261, 79, 2, 27, "Input"],
Cell[7658, 265, 41, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[7736, 271, 541, 14, 47, "Input"],
Cell[8280, 287, 773, 19, 47, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[9090, 311, 507, 14, 29, "Input"],
Cell[9600, 327, 590, 13, 47, "Output"]
}, Closed]],
Cell[10205, 343, 225, 5, 50, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[10455, 352, 100, 2, 44, "Input"],
Cell[10558, 356, 38, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[10633, 362, 85, 2, 27, "Input"],
Cell[10721, 366, 35, 1, 27, "Output"]
}, Closed]],
Cell[10771, 370, 130, 3, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[10926, 377, 106, 3, 43, "Input"],
Cell[11035, 382, 44, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[11116, 388, 541, 14, 47, "Input"],
Cell[11660, 404, 510, 12, 29, "Output"]
}, Closed]],
Cell[12185, 419, 121, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[12331, 425, 529, 14, 45, "Input"],
Cell[12863, 441, 359, 8, 29, "Output"]
}, Closed]],
Cell[13237, 452, 100, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[13362, 458, 527, 12, 44, "Input"],
Cell[13892, 472, 70, 1, 29, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[13999, 478, 79, 2, 27, "Input"],
Cell[14081, 482, 91, 1, 32, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[14209, 488, 89, 2, 27, "Input"],
Cell[14301, 492, 38, 1, 27, "Output"]
}, Closed]],
Cell[14354, 496, 389, 7, 86, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[14768, 507, 316, 6, 91, "Input"],
Cell[15087, 515, 85, 1, 45, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[15209, 521, 89, 2, 27, "Input"],
Cell[15301, 525, 38, 1, 27, "Output"]
}, Closed]],
Cell[15354, 529, 93, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[15472, 535, 101, 2, 41, "Input"],
Cell[15576, 539, 86, 1, 42, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[15699, 545, 156, 3, 44, "Input"],
Cell[15858, 550, 62, 1, 43, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[15957, 556, 108, 3, 43, "Input"],
Cell[16068, 561, 55, 1, 27, "Output"]
}, Closed]],
Cell[16138, 565, 102, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[16265, 571, 90, 2, 27, "Input"],
Cell[16358, 575, 38, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[16445, 582, 107, 2, 36, "Section",
  Evaluatable->False],
Cell[16555, 586, 327, 6, 68, "Text",
  Evaluatable->False],
Cell[16885, 594, 284, 7, 108, "Input",
  InitializationCell->True]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

CellGroupData[{
Cell[11548, 366, 100, 3, 70, "Input"],
Cell[11651, 371, 93, 3, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[11776, 376, 535, 14, 70, "Input"],
Cell[12314, 392, 1380, 34, 70, "Output"]
}, Closed]],
Cell[13706, 428, 121, 2, 70, "Text"],

Cell[CellGroupData[{
Cell[13850, 432, 523, 14, 70, "Input"],
Cell[14376, 448, 786, 20, 70, "Output"]
}, Closed]],
Cell[15174, 470, 100, 2, 70, "Text"],

Cell[CellGroupData[{
Cell[15297, 474, 523, 12, 70, "Input"],
Cell[15823, 488, 118, 3, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[15973, 493, 79, 2, 70, "Input"],
Cell[16055, 497, 126, 3, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[16213, 502, 89, 2, 70, "Input"],
Cell[16305, 506, 87, 3, 70, "Output"]
}, Closed]],
Cell[16404, 511, 389, 7, 70, "Text"],

Cell[CellGroupData[{
Cell[16816, 520, 304, 6, 70, "Input"],
Cell[17123, 528, 120, 3, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[17275, 533, 89, 2, 70, "Input"],
Cell[17367, 537, 87, 3, 70, "Output"]
}, Closed]],
Cell[17466, 542, 93, 2, 70, "Text"],

Cell[CellGroupData[{
Cell[17582, 546, 101, 2, 70, "Input"],
Cell[17686, 550, 121, 3, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[17839, 555, 145, 4, 70, "Input"],
Cell[17987, 561, 97, 3, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[18116, 566, 102, 3, 70, "Input"],
Cell[18221, 571, 90, 3, 70, "Output"]
}, Closed]],
Cell[18323, 576, 102, 2, 70, "Text"],

Cell[CellGroupData[{
Cell[18448, 580, 90, 2, 70, "Input"],
Cell[18541, 584, 87, 3, 70, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[18669, 589, 107, 2, 70, "Section"],
Cell[18779, 593, 327, 6, 70, "Text"],
Cell[19109, 601, 293, 8, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)
